// clock line -kfi0 -kff99 -ki0 -kf99

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "wetter.inc"

     
// 00 -- trocken 
#declare wb00 =
union {
  object { Rect(1,1) }
} 
// 01 -- feucht 
#declare wb01 =
union {
  object { Rect(1,1) }
  object { Disk(0.2) }
} 
// 02 -- na 
#declare wb02 =
union {
  object { Rect(1,1) }
  object { Disk(0.2) translate -0.3*y }
  object { Disk(0.2) translate  0.3*y }
} 
// 03 -- berflutet 
#declare wb03 =
union {
  object { Rect(1,1) }
  object { Disk(0.2) translate<   0, 0.3,0> }
  object { Disk(0.2) translate<-0.3,-0.3,0> }
  object { Disk(0.2) translate< 0.3,-0.3,0> }
} 
// 04 -- gefroren 
#declare wb04 =
union {
  object { Rect(1,1) }
  object { Line(1) translate -0.4*y }
}                                                                          

#declare Wave =
union {
  object { QuarterCirc(0.55) rotate -135*z translate<  0.0, 0.35, 0> }
  object { QuarterCirc(0.55) rotate   45*z translate<-0.65,-0.35, 0> }
  object { QuarterCirc(0.55) rotate   45*z translate< 0.65,-0.35, 0> }
}
// 05 -- Glatteis oder Eisgltte (mindestens 50 % des Erdbodens bedeckend) 
#declare wb05 =
union {
  object { Rect(1,1) }      
  object { Wave translate -0.3*y }
} 
// 06 -- loser, trockener Sand -- den Boden nicht vollstndig bedeckend 
#declare wb06 =
union {
  object { RectO(1,1) }
  object { wwS(0.4) }
} 
// 07 -- geschlossene dnne Sandschicht -- den Boden vollstndig bedeckend 
#declare wb07 =
union {
  object { Rect(1,1) }
  object { wwS(0.4) }
} 
// 08 -- geschlossene dicke Sandschicht -- den Boden vollstndig bedeckend 
#declare wb08 =
union {
  object { wb07 }
  object { Line(0.9) rotate 90*z }
} 
// 09 -- extrem trockener Boden mit Rissen 
#declare wb09 =
union {
  object { Rect(1,1) }
  text { ttf "timrom.ttf" "D" 1, 0 translate <-0.35,-0.35,0> scale <2,2,0.01> }
} 
// 10 -- vorwiegend (> 50 %) mit Eis bedeckt (Hagel-/Graupel-/Grieseldecke) 
#declare wb10 =
union {
  object { Rect(1,1) }
  object { Wave translate -0.2*y }
  object { Wave translate -0.6*y }
} 
// 1 -- kompakter oder nasser Schnee -- weniger als die Hlfte des Bodens bedeckend (Fl)
#declare wb11 =
union {
  object { RectLU(1,1) } 
  object { Schnee(0.5) }
} 
// 2 -- kompakter oder nasser Schnee -- mehr als die Hlfte, aber den Boden nicht vollstndig bedeckend (dbr)
#declare wb12 =
union {
  object { RectO(1,1) } 
  object { Schnee(0.5) }
}
// 3 -- ebene Schicht kompakten oder nassen Schnees -- den gesamten Boden bedeckend
#declare wb13 =
union {
  object { Rect(1,1) } 
  object { Schnee(0.5) }
} 
// 4 -- unebene Schicht kompakten oder nassen Schnees -- den gesamten Boden bedeckend
#declare wb14 =
union {
  object { Rect(1,1) } 
  object { Line( sqrt(2) ) rotate 45*z }
  object { Schnee(0.5) translate <-0.4,0.4,0> }
} 
// 5 -- loser, trockener Schnee -- weniger als die Hlfte des Bodens bedeckend (Fl)
#declare wb15 =
union {
  object { RectLU(1,1) } 
  object { PfeilR(0.7) rotate -90*z translate <0.4,0.1,0> }
  object { Schnee(0.5) translate -0.4*x }
} 
// 6 -- loser, trockener Schnee -- mehr als die Hlfte, aber den Boden nicht vollstndig bedeckend (dbr)
#declare wb16 =
union {
  object { RectO(1,1) } 
  object { PfeilR(0.7) rotate -90*z translate <0.4,0.1,0> }
  object { Schnee(0.5) translate -0.4*x }
} 
// 7 -- ebene Schicht losen, trockenen Schnees -- den gesamten Boden bedeckend
#declare wb17 =
union {
  object { Rect(1,1) } 
  object { PfeilR(0.7) rotate -90*z translate <0.4,0.1,0> }
  object { Schnee(0.5) translate -0.4*x }
} 
// 8 -- unebene Schicht losen, trockenen Schnees -- den gesamten Boden bedeckend
#declare wb18 =
union {
  object { Rect(1,1) } 
  object { Line( sqrt(2) ) rotate 45*z }
  object { Schnee(0.5) translate <-0.4,0.4,0> }
  object { PfeilR(0.4) rotate -90*z translate <0.5,-0.2,0> }
} 
// 9 -- vollstndig geschlossene Schneedecke mit hohen Verwehungen (> 50 cm)
#declare wb19 =
union {
  object { Rect(1,1) }
  object { Line( sqrt(2) ) rotate 45*z }
  object { Schnee(0.5) translate <-0.4,0.4,0> }
  object { PfeilR(0.4) translate <0.2,-0.5,0> }
}
// / -- Reste (< 10 %) von Schnee oder Eis (Hagel/Graupel/Griesel)
#declare wb20 =
union {
  object { Line(1) translate -y }
  object { Schnee(0.5) }
}

// 21-Tau
#declare wb21 =
union {
  object { Rect(1,1) }
  object { Niesel }
}
// Reif
#declare wb22 =
union {
  object { Rect(1,1) }
  object { Line(1) translate -0.4*y }
  object { Schnee(0.5) translate <0,0.0,0> }
}                                                                          


#switch (clock)
  #case (0)  object { wb00 }
             #break
  #case (1)  object { wb01 }
             #break
  #case (2)  object { wb02 }
             #break
  #case (3)  object { wb03 }
             #break
  #case (4)  object { wb04 }
             #break
  #case (5)  object { wb05 }
             #break
  #case (6)  object { wb06 }
             #break
  #case (7)  object { wb07 }
             #break
  #case (8)  object { wb08 }
             #break
  #case (9)  object { wb09 }
             #break
  #case (10) object { wb10 }
             #break
  #case (11) object { wb11 }
             #break
  #case (12) object { wb12 }
             #break
  #case (13) object { wb13 }
             #break
  #case (14) object { wb14 }
             #break
  #case (15) object { wb15 }
             #break
  #case (16) object { wb16 }
             #break
  #case (17) object { wb17 }
             #break
  #case (18) object { wb18 }
             #break
  #case (19) object { wb19 }
             #break
  #case (20) object { wb20 }
             #break
  #case (21) object { wb21 }
             #break
#end

sky_sphere {
  pigment {
    White
  }  
}

camera {
   location <0,0,-15>
   direction <0.0, 0.0, 6>
   up <0.0, 1.0, 0.0>      // Kwadratisch
   right <1.0, 0.0, 0.0>
   look_at <0,0,0>
}
