// clock line -kfi0 -kff99 -ki0 -kf99

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "wetter.inc"

     
// 0 -- hher, erst steigend, dann fallend
#declare ld0 =
union {
  object { Disk(0.075) }
  object { Line(1) translate -x rotate 45*z }
  object { Line(0.5) translate 0.5*x rotate -45*z }          
  translate <0.35,0.7,0>
} 
// 1 -- hher, erst steigend, dann gleichbleibend
#declare ld1 =
union {
  object { Disk(0.075) }
  object { Line(1) translate -x rotate 45*z }
  object { Line(0.4) translate 0.4*x }          
  translate <0.35,0.7,0>
} 
// 2 -- hher, konstant steigend
#declare ld2 =
object { Line(1.25) rotate 45*z }
// 3 -- hher, erst fallend, dann steigend
#declare ld3 =
object { ld0 rotate 180*z }
// 4 -- gleichbleibend oder minimale nderung
#declare ld4 =
object { Line(1) }
// 5 -- tiefer, erst fallend, dann steigend
#declare ld5 =
object { ld3 scale <-1,1,1> }
// 6 -- tiefer, erst fallend, dann gleichbleibend
#declare ld6 =
object{ ld1 scale <1,-1,1> }
// 7 -- tiefer, konstant fallend 
#declare ld7 =
object { Line(1.25) rotate-45*z }
// 8 -- tiefer, erst steigend, dann fallend
#declare ld8 =
object { ld0 scale <-1,1,1> }


#switch (clock)
  #case (0)  object { ld0 }
             #break
  #case (1)  object { ld1 }
             #break
  #case (2)  object { ld2 }
             #break
  #case (3)  object { ld3 }
             #break
  #case (4)  object { ld4 }
             #break
  #case (5)  object { ld5 }
             #break
  #case (6)  object { ld6 }
             #break
  #case (7)  object { ld7 }
             #break
  #case (8)  object { ld8 }
             #break
#end

sky_sphere {
  pigment {
    White
  }  
}

camera {
   location <0,0,-15>
   direction <0.0, 0.0, 6>
   up <0.0, 1.0, 0.0>      // Kwadratisch
   right <1.0, 0.0, 0.0>
   look_at <0,0,0>
}
