#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

#declare STEPS=16;
//#declare CLK=clock;
#declare BLK = texture {
  pigment { Black }
  finish { ambient 1 diffuse 0 }
}

#declare spr =
sphere { 0,1
  texture { BLK }
}

#declare FullCirc =
cylinder { <0,0,-0.001><0,0,0.001> 1
  texture { BLK }
}
#declare HollowCirc =
difference {
  object { FullCirc }
  object { FullCirc scale <0.9,0.9,1.1> }
}
#declare Part1Circ =
union { 
  object { HollowCirc }
  box { <-0.05,-0.98,-0.001><0.05,0.98,0.001> texture { BLK } }
}
#declare QuarterCirc =
intersection { 
  object { FullCirc }
  box { <0,0,-0.1><2,2,0.1> }
  texture { BLK }
}
#declare HalfCirc =
difference { 
  object { FullCirc }
  plane { x,0 }
  texture { BLK }
}

#switch (clock)
  #case(0)
    object { HollowCirc }
  #break
  #case(1)
    object { Part1Circ }
  #break
  #case(2)
    union {
      object { HollowCirc }
      object { QuarterCirc }
    }
  #break
  #case(3)
    union {
      object { Part1Circ }
      object { QuarterCirc }
    }
  #break
  #case(4)
    union {
      object { HollowCirc }
      object { HalfCirc }
    }
  #break
  #case(5)
    union {
      object { Part1Circ rotate -z*90 }
      object { HalfCirc }
    }
  #break
  #case(6)
    union {
      object { HollowCirc }
      object { HalfCirc rotate -z*90 }
      object { HalfCirc }
    }
  #break
  #case(7)
    difference {
      object { FullCirc }
      box { <-0.07,-0.85,-0.1><0.07,0.85,0.1> texture { BLK } }
    }
  #break
  #case(8)
    object { FullCirc }
  #break
  #case(9)
    union {
      object { Part1Circ rotate -z*45 }
      object { Part1Circ rotate z*45 }
    }
  #break
#end

sky_sphere {
  pigment {
    White
  }  
}

camera {
   location <0,0,-13>
   direction <0.0, 0.0, 6>
   up <0.0, 1.0, 0.0>      // Kwadratisch
   right <1.0, 0.0, 0.0>
   look_at <0,0,0>
}
