#declare BLK = texture {
  pigment { Black }
  finish { ambient 1 diffuse 0 }
}

#macro Circ(Radius)
// Vollkreis
difference {
  cylinder { <0,0,-0.01><0,0,0.01>,Radius }
  cylinder { <0,0,-0.02><0,0,0.02>,Radius-0.15 }
  texture { BLK }
}
#end
#macro Rect(Sx,Sy)
// Rechteck
difference {
  box { UnitBox scale <Sx+0.075,Sy+0.075,0.01> }
  box { UnitBox scale <Sx-0.075,Sy-0.075,0.02> }
  texture { BLK }
}  
#end
#macro RectO(Sx,Sy)
// Rechteck, oben offen
difference {
  box { UnitBox scale <Sx+0.075,Sy+0.075,0.01> }
  box { UnitBox scale <Sx-0.075,Sy+0.075,0.02> translate 0.15*y }
  texture { BLK }
}       
#end
#macro RectLU(Sx,Sy)
// Rechteck, rechts oben offen
difference {
  box { UnitBox scale <Sx+0.075,Sy+0.075,0.01> }
  box { UnitBox scale <Sx+0.075,Sy+0.075,0.02> translate <0.15,0.15,0> }
  texture { BLK }
}
#end
#macro Disk(Radius)
// ausgefllter Vollkreis
cylinder { <0,0,-0.01><0,0,0.01>,Radius
  texture { BLK }
}
#end
#macro HalfCirc(Radius)
// Halbpreis (rechts)
difference {
  object { Circ(Radius) }
  plane { x,0 } 
  texture { BLK }
}
#end
#macro QuarterCirc(Radius)
// Viertelkreis (rechts/oben)
difference {
  object { HalfCirc(Radius) }
  plane { y,0 } 
  texture { BLK }
}
#end
// dnne Linie
#macro Line(Length)
  box { <-Length,-0.075,-0.01><Length,0.075,0.01> }
#end          
// dicke Linie
#macro Lineb(Length)
  box { <-Length,-0.1,-0.01><Length,0.1,0.01> }
#end

// ---------------------------------

#macro PfeilR(Len)
union {
  object { Line(Len) }
  difference {
    box { UnitBox rotate 45*z scale <0.28,0.28,0.01> }
    plane { x,0 }
    translate 0.8*Len*x
  }
  texture { BLK }
}
#end
#macro PfeilBR(Len)
// Pfeil rechts, dick
union {
  object { Lineb(Len) translate -0.05*y }
  object { Lineb(Len) translate  0.05*y }
  difference {
    box { UnitBox rotate 45*z scale <0.28,0.28,0.01> }
    plane { x,0 }
    translate 0.8*Len*x
  }
  texture { BLK }
}
#end
#macro PfeilDR(Len)  
// Doppelfleil rechts
union {
  object { Line(Len) translate -0.17*y}
  object { Line(Len) translate  0.17*y}
  difference {
    box { UnitBox rotate 45*z scale <0.35,0.35,0.01> }
    plane { x,0 }
    translate 0.74*Len*x
  }
  texture { BLK }
}
#end
#declare Klammer =
intersection {
  difference {
    cylinder { <0,0,-0.01><0,0,0.01> 1.5 }
    cylinder { <0,0,-0.02><0,0,0.02> 1.7 translate 0.35*x}
  }
  cylinder { <0,0,-0.02><0,0,0.02> 1 translate -x }
  texture { BLK }
  translate 1.3*x
}
#declare KlammerE =
difference {
  object { Line(1) rotate 90*z scale <3,1,1> }
  object { Line(0.85) rotate 90*z scale <3,1,2> translate -0.13*x }
}
#macro wwS(Size)
// groes 'S'
union {
  object { HalfCirc(Size) translate <Size/2,0.075-Size,0>}
  object { HalfCirc(Size) rotate 180*z translate <-Size/2,Size-0.075,0>}
  object { Line(Size/2) }
  rotate -40*z
  texture { BLK }
}
#end



#declare Niesel =
union {
  object { Disk(0.2) }
  difference {
    object { Disk(0.25) }
    object { Disk(0.25) scale <1,1,2> translate <-0.18,-0.1,0> }
    plane { y,0 rotate 30*z translate 0.1*y inverse }
    translate <-0.03,-0.2,0>
  }
}

#macro Schnee(Size)
union {
  object { Line(Size) }
  object { Line(Size) rotate 60*z }
  object { Line(Size) rotate -60*z }
  scale 0.65
}
#end
