#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

#declare STEPS=16;
//#declare CLK=clock;
#declare BLK = texture {
  pigment { Black }
  finish { ambient 1 diffuse 0 }
}

#macro Circ(Radius)
// Vollkreis
difference {
  cylinder { <0,0,-0.01><0,0,0.01>,Radius }
  cylinder { <0,0,-0.02><0,0,0.02>,Radius-0.1-0.1 }
  texture { BLK }
}
#end
#macro Disk(Radius)
// ausgefllter Vollkreis
cylinder { <0,0,-0.01><0,0,0.01>,Radius
  texture { BLK }
}
#end
#macro HalfCirc(Radius)
// Halbpreis (rechts)
difference {
  object { Circ(Radius) }
  plane { x,0 }
  texture { BLK }
}
#end
#macro QuarterCirc(Radius)
// Viertelkreis (rechts/oben)
difference {
  object { HalfCirc(Radius) }
  plane { y,0 }
  texture { BLK }
}
#end
#macro Line(Length)
  box { <-Length,-0.1,-0.01><Length,0.1,0.01> }
#end

#declare ch_a =
// 'Haken' fr ch5,7 und 8
union {
  object { Line(0.5) translate <0.5,0,0> }
  union {
    object { Disk(0.1) translate <0.965,0.035,0> }
    object { HalfCirc(0.4) translate <0,0.35,0> rotate <0,0,45> translate <1,0,0> }
    translate <0.02,-0.033,0>
  }
  rotate <0,0,45>
  translate <0,-0.3,0>
}

#declare cbase1 =
// 'W' fr ch9 und cm4
union {
  object { HalfCirc(0.5) rotate <0,0,-90> translate <-0.4,0,0> }
  object { HalfCirc(0.5) rotate <0,0,-90> translate < 0.4,0,0> }
  intersection {
    object { QuarterCirc(0.75) }
    plane { y,0 rotate <0,0,45> }
    translate < 0.15,0,0>
  }
}

// ----------------------------------------------------------------
#declare ch1 =
union {
  object { Line(1) }
  object { QuarterCirc(1) }
  translate <0,-0.3,0>
}
#declare ch2 =
union {
  object { Line(1) }
  object { QuarterCirc(1) }
  object { QuarterCirc(0.7) }
  translate <0,-0.3,0>
}
#declare ch3 =
union {
  object { Line(0.8) translate <-0.2,0,0>}
  object { HalfCirc(0.5) translate <0.6,0.4,0> }
  translate <0,-0.3,0>
}
#declare ch4 =
union {
  object { Line(1) translate <0,0.0385,0> }
  object { Disk(0.1) translate <0.963,0.037,0> }
  object { HalfCirc(0.5) translate <0,0.45,0> rotate <0,0,45> translate <1,0,0> }
  rotate <0,0,45>
  translate <0,-0.3,0>
}
#declare ch5 =
union {
  object { Line(0.8) }
  object { Disk(0.1) translate <-0.8,0,0> }
  object { ch_a translate <-0.813,0.285,0> }
  translate <0,-0.3,0>
}
#declare ch6 =
union {
  union {
    object { Line(1) }
    object { Disk(0.1) translate <1,0,0> }
    object { HalfCirc(0.5) translate <0,0.45,0> rotate <0,0,45> translate <1.035,-0.035,0> }
    object { Disk(0.1) translate <-1,0,0> }
    rotate <0,0,45>
  }
  object { Line(0.3) translate <-1/sqrt(2)+0.3,-1/sqrt(2),0> }
  translate <0,-0.3,0>
}
#declare ch7 =
union {
  object { Line(0.8) }
  object { Disk(0.1) translate <-0.8,0,0> }
  object { Disk(0.1) translate < 0.8,0,0> }
  object { ch_a translate <-0.813,0.285,0> }
  object { ch_a scale <-1,1,1> translate <0.813,0.285,0> }
  translate <0,-0.3,0>
}
#declare ch8 =
union {
  object { Line(0.8) }
  object { Disk(0.1) translate <-0.8,0,0> }
  object { Disk(0.1) translate < 0.8,0,0> }
  object { ch_a scale <-1,1,1> translate <0.813,0.285,0> }
  translate <0,-0.3,0>
}
#declare ch9 =
union {
  object { cbase1 }
  intersection {
    object { QuarterCirc(0.7) }
    plane { y,0 rotate <0,0,30> inverse }
    rotate <0,0,90>
    translate <-0.2,0,0>
  }
  difference {
    object { Circ(0.4) }
    difference {
      plane { y,0 }
      plane { x,0 rotate <0,0,30> inverse }
    }
    translate <-0.78+0.105,0.85-0.087,0>
  }
  translate <0.1,-0.3,0>
}
// -----------------------------------------------------
#declare cm1 =
union {
  object { Line(1) }
  object { Line(1) translate x rotate 25*z translate -x }
  object { Disk(0.1) translate <-1,0,0> }
  translate -0.25*y
}
#declare cm2 =
union {
  object { Line(1) }
  object { Line(1) translate x rotate 25*z translate -x }
  object { Line(0.7) translate 0.7*x rotate 25*z translate -0.35*x }
  object { Disk(0.1) translate <-1,0,0> }
  translate -0.25*y
}
#declare cm3 =
union {
  object { cbase1 }
  intersection {
    object { QuarterCirc(1.1) }
    plane { y,0 rotate <0,0,15> inverse }
    rotate <0,0,90>
    translate <0.2,0,0>
  }
  translate <0.1,-0.3,0>
}
#declare cm4 =
union {
  object { Line(0.8) }
  object { HalfCirc(0.6) rotate 180*z translate <-0.8,-0.5,0> }
  object { HalfCirc(0.6) rotate 225*z translate <-0.8,-0.5,0> }
  rotate 45*z
  translate 0.5*y
}
#declare cm5 =
union {
  object { HalfCirc(0.55) rotate <0,0,-90> translate <-0.45,0,0> }
  object { HalfCirc(0.55) rotate <0,0,-90> translate < 0.45,0,0> }
  object { HalfCirc(0.55) rotate <0,0,-135> translate <-0.45,0,0> }
  object { Line(0.5) translate <0.45,0.45,0> rotate 45*z translate -0.45*x }
  translate -0.3*y
}
#declare cm6 =
union {
  union {
    object { HalfCirc(0.55) rotate <0,0,-90> translate <-0.45,0,0> }
    object { HalfCirc(0.55) rotate <0,0,-90> translate < 0.45,0,0> }
    translate 0.9*y
  }
  union {
    object { HalfCirc(1) rotate 90*z translate -y*0.1 }
    object { Line(0.95) }
    translate -0.9*y
  }
}
#declare cm7 =
union {
  union {
    object { HalfCirc(0.575) rotate <0,0,-90> translate <-0.475,-0.05,0> }
    object { HalfCirc(0.575) rotate <0,0,-90> translate < 0.475,-0.05,0> }
    //translate -0.5*y
  }
  union {
    object { Line(1.05) }
    //object { Disk(0.05) translate -x }
    object { Line(0.7) translate 0.7*x rotate 45*z translate -0.982*x translate 0.018*y }
  }
}
#declare cm8 =
union {
  object { HalfCirc(1) rotate -90*z translate 0.9*y }
  object { Line(0.9) rotate 90*z translate -0.9*x }
  object { Line(0.9) rotate 90*z translate  0.9*x }
}
#declare cm9 =
union {
  object { Line(0.6) translate -0.05*y }
  object { HalfCirc(0.5) rotate 180*z translate <-0.6,-0.45,0> }
  object { HalfCirc(0.5) rotate 225*z translate <-0.6,-0.45,0> }
  object { HalfCirc(0.8) rotate 225*z translate <-0.6,-0.45,0> }
  rotate 45*z
  translate 0.5*y
}
// ------------------------------------------------------
#declare cl1 =
union {
  object { HalfCirc(1) rotate 90*z translate -0.1*y }
  object { Line(0.95) }
  translate -0.4*y
}
#declare cl2 =
union {
  object { cl1 }
  object { HalfCirc(0.5) rotate 90*z translate 0.35*y}
  translate -0.2*y
}
#declare cl3 =
union {
  object { cl2 }
  object { Line(0.4) rotate 90*z translate 0.2*y}
}
#declare cl5 =
union {
  object { HalfCirc(0.5) rotate -90*z }
  object { Line(0.35) translate -0.65*x }
  object { Line(0.35) translate  0.65*x }
}
#declare cl4 =
union {
  object { HalfCirc(1) rotate 90*z }
  object { cl5 }
  translate -0.3*y
}
#declare cl6 =
union {
  object { Line(1) }
}
#declare cl7 =
union {
  object { Line(0.25) }
  object { Line(0.25) translate -0.75*x }
  object { Line(0.25) translate  0.75*x }
}
#declare cl8 =
union {
  object { cl1 translate -0.55*y}
  object { cl5 translate  0.55*y}
  translate 0.2*y
}
#declare cl9 =
union {
  object { cl1 translate -0.55*y}
  difference {
    union {
      object { Line(0.65) translate -0.1*y }
      object { HalfCirc(0.7) rotate -90*z }
    }
    cylinder { <0,0,-1><0,0,1> 1 translate -1.4*y }
    translate 0.3*y
  }
  translate 0.4*y
}

#switch (clock)
  #case (0)
             #break
  #case (1)  object { ch1 }
             #break
  #case (2)  object { ch2 }
             #break
  #case (3)  object { ch3 }
             #break
  #case (4)  object { ch4 }
             #break
  #case (5)  object { ch5 }
             #break
  #case (6)  object { ch6 }
             #break
  #case (7)  object { ch7 }
             #break
  #case (8)  object { ch8 }
             #break
  #case (9)  object { ch9 }
             #break
  #case (11) object { cm1 }
             #break
  #case (12) object { cm2 }
             #break
  #case (13) object { cm3 }
             #break
  #case (14) object { cm4 }
             #break
  #case (15) object { cm5 }
             #break
  #case (16) object { cm6 }
             #break
  #case (17) object { cm7 }
             #break
  #case (18) object { cm8 }
             #break
  #case (19) object { cm9 }
             #break
  #case (21) object { cl1 }
             #break
  #case (22) object { cl2 }
             #break
  #case (23) object { cl3 }
             #break
  #case (24) object { cl4 }
             #break
  #case (25) object { cl5 }
             #break
  #case (26) object { cl6 }
             #break
  #case (27) object { cl7 }
             #break
  #case (28) object { cl8 }
             #break
  #case (29) object { cl9 }
             #break
#end

sky_sphere {
  pigment {
    White
  }
}

camera {
   location <0,0,-15>
   direction <0.0, 0.0, 6>
   up <0.0, 1.0, 0.0>      // Kwadratisch
   right <1.0, 0.0, 0.0>
   look_at <0,0,0>
}
