#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

//#declare CLK=12;
#declare CLK=clock;

#declare Plate =
union {
  box {<-1,-1,-1><1,1,1>
    scale <5,0.5,5>
    pigment { color Gray75 }
  }
}                   
#declare SkyPlate=
object { 
  UnitBox
  translate <0,0,1> 
  scale <100,1,100>    
  translate <0,50,0>
  pigment { 
    bozo 
    color_map {
      [0 color rgb <0,0,1>]
      [1 color rgb <0.7,0.7,1>]
    }
    scale 3
  }
}
     

#declare _Date =
union {
  box { <-3,0,-1.5><3,8,1.5> 
    pigment { color White }
    finish { ambient 0.5 }
  }
  box { <-3.1,8,-1.6><3.1,10,1.6> 
    pigment { color Black }
    finish { ambient 0.5 }
  }
  text { ttf "timrom.ttf" "1" 1, 0
    pigment { Black }
    scale <7,6,1>
    translate <-1,2.5,-1.5001>
  }
  text { ttf "timrom.ttf" "Montag" 1, 0
    pigment { Black }
    scale <1.5,1,1>
    translate <-2.5,7,-1.5001>
  }
  text { ttf "timrom.ttf" "Januar" 1, 0
    pigment { Black }
    scale <1.5,1,1>
    translate <-2.2,1,-1.5001>
  }
}

#declare Termo =
union {  
  sphere { <0,0,0> 3 }
  cylinder { <0,0,0><0,15,0> 1.5 }
  sphere { <0,15,0> 1.5 }
  pigment { gradient y
    color_map {
      [ 0.0 color Blue ]
      [ 1.0 color rgb <1,0.3,0.3>  ]
      // [ 1.0 color Blue  ]
    }
    scale <1,40,1>
    translate <0,-20,0>
  }
  finish { ambient 0.3 }
  translate <0,3,0>
  scale 0.667
}                             
#declare _WindS =  // Windstrke
union {
  union {
    torus { 2, 0.25 
      rotate <90,0,0>
      translate <0,8,0>
    } 
    cylinder { <0,0,0><0,6,0> 0.25 }
    pigment { color Gray75 }
  }
  difference {
    cone {
      <0,8,0> 2
      <0,8,10> 1.5
    }  
    cone {
      <0,8,-0.1> 1.95
      <0,8,10.1> 1.45
    }  
    pigment {
      gradient z 
      color_map {
        [0  0.5 color White color White]
        [0.5  1 color Red color Red]
      }
      scale <1,1,3>
    }
    finish {
      ambient 0.5
    }
  }  
}
#declare _WindD = // Windrichtung
union {
  union {
    cylinder { <0,0,0><0,10,0> 0.25 }
    cylinder { <-3,6,0><3,6,0> 0.25 }
    torus { 2, 0.25
      rotate <90,0,0>
      translate <0,6,0>
    }
    pigment { color Gray75 }
  }  
  union {        // Pfeil  
    intersection {
      object { 
        UnitBox
        scale <1,1,0.25>
        rotate <0,0,45>
      }         
      plane {x,0}
    }
    difference {
      intersection {
        object { 
          UnitBox
          rotate <0,0,45>
          scale <10,1,0.25>
          translate <7,0,0>
        }         
        plane {-x,0}
      }  
      object {
        UnitBox
        rotate <0,0,45>
        scale 10
        translate <20,0,0>
      }
    }  
    translate <-3,10,0>
    rotate <0,-25,0>
    pigment { color White }
    finish { ambient 0.3 }
  }
}
#declare _Lake=
union {     
  blob { // Pftz   
    threshold 0.2

    sphere { <0,0,0>   4,1 }
    sphere { <2.5,0,2>   3,1 }
    sphere { <2.5,0,-1> 2.5,1 }
    sphere { <2,0,-3>  2,1 }
    sphere { <-1,0,-2> 3,1 }
    sphere { <-2,0,1.5> 3,1 }
    scale <1,0.01,1>
    translate <0,0.499,0>
    pigment { color rgb <0.5,0.5,1.0> }
    normal {
      ripples 0.25
    }
    finish {
      reflection 0.75
      refraction 0.25
      ior 1.7
    }
  }
}
  
#declare _DrewSphere =
sphere { <0,0,0> 1 
  scale <1,0.25,1>
  pigment { color rgbf <0.7,0.7,1,0.8> }
  finish {
    reflection 0.2
    refraction 0.8
  }               
  interior { ior 1.33333 }
}
            
#declare _Drew =
union {
  object { SkyPlate }
  object { _DrewSphere scale 1.0 translate <-1,0.4,-4> }
  object { _DrewSphere scale 1.5 translate <-3.5,0.4, 3> }
  object { _DrewSphere scale 1.0 translate < 1,0.4, 0> }
  object { _DrewSphere scale 1.2 translate <-2,0.4, 0> }
  object { _DrewSphere scale 1.6 translate < 3,0.4,-2> }
  object { _DrewSphere scale 1.1 translate < 1,0.4, 3.5> }
  object { _DrewSphere scale 1.3 translate < 0,0.4,-2> }
  object { _DrewSphere scale 1.4 translate <-1,0.4, 2> }
  object { _DrewSphere scale 1.3 translate <-3,0.4,-3> }
  object { _DrewSphere scale 1.6 translate < 3,0.4, 2> }
}

#declare _RainDrop=
merge {
  sphere { <0,0,0> 1 }
  cone { <0,0,0> 0.9
         <0,2.5,0> 0
         translate <0,0.45,0> }
  //pigment { color rgb <0.5,0.5,1.0> }
  pigment { color rgbf <0.75,0.75,1,0.75> }
  finish {
    reflection 0.2
    refraction 0.8
  }
  interior{ ior 1.33 }
}
#declare _Rain=
union {
  object { SkyPlate }
  object { _Lake }
  object { _RainDrop scale 1.0 translate < 0,5,-3> }
  object { _RainDrop scale 0.9 translate < 2,7, 5> }
  object { _RainDrop scale 1.1 translate <-3,2,-1> }
  object { _RainDrop scale 1.2 translate < 4,4, 2> }
  object { _RainDrop scale 0.8 translate <-1,8, 4> }
  object { _RainDrop scale 1.0 translate < 0,1,-4> }
  object { _RainDrop scale 0.9 translate <-1,3, 2> }
  object { _RainDrop scale 1.1 translate < 4,9,-2> }
  object { _RainDrop scale 0.8 translate < 3,2,-4> }
  object { _RainDrop scale 1.0 translate <-4,3,-4> }
  object { _RainDrop scale 1.2 translate <-3,8,-5> }
  object { _RainDrop scale 1.2 translate <-4,5, 3> }
}

#declare _Sun =
union {
  sphere { <0,0,0> 5 }
  #local Ang=0;
  #while (Ang<360)
    cone { <5,0,0> 1 <8,0,0> 0 rotate  z*Ang}
    #local Ang=Ang+20;
  #end
  pigment { color rgb <1,1,0> }
  finish {
    ambient 0.5 
  }
}

#declare Atmosphere1 = media {
  emission 0.1
  absorption 0.1
  intervals 5
  samples 25,150 //100, 100
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 0.5
    color_map {
      [0.0 color rgb <0.0, 0.0, 0.0>]
      [0.3 color rgb <1.0, 1.0, 1.0>]
      [1.0 color rgb <1.0, 1.0, 1.0>]
    }
  }
  rotate <0,90,0>
} 

#declare _Hum =
union {
  sphere { <0,0,0> 2
    pigment { color rgbf<1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 }
    interior { media { Atmosphere1 } }  
    hollow
  }
  scale 7
  translate <0,7,0>
}

#declare _Baro =
union {
  union {
    cylinder { <0,0,0><0,0,0.5> 5 }
    torus { 4.5,0.5 rotate <90,0,0> }
    pigment { color Gray75 }
    finish { ambient 0.5 }
  }
  cylinder { <0,0,0><0,0,-0.1> 4.5 
    pigment { color White }
    finish { ambient 0.5 }
  }
  cylinder { <0,0,0><0,0,-0.3> 0.5
    pigment { Black }
  }
  triangle { <0,4,-0.3><-0.3,0,-0.3><0.3,0,-0.3> rotate <0,0,30>
    pigment { Black }
  }
  union {
    cylinder { <0,0,0><0,0,-0.2> 1 }
    #local Ang=0;
    #while (Ang<360)
      box { <-0.2,-0.2,-0.2><0.2,0.2,0.2> rotate <0,0,45> scale <1,2,1> translate <0,1,0> rotate <0,0,Ang> }
      #local Ang=Ang+30;
    #end
    pigment { Black }
    scale <0.7,0.7,1>
    translate <2.2,1,0>
  }
  union {
    cylinder { <0,0,0><0,0,-0.2> 1 translate <-0.6,0,0> }
    cylinder { <0,0,0><0,0,-0.2> 1 translate <0.6,0,0> }
    cylinder { <0,0,0><0,0,-0.2> 1 translate <0,0.4,0> }
    box { <-0.1,-0.8,-0.2><0,0,0> rotate <0,0,-30> translate <-0.8,-1.1,0> }
    box { <-0.1,-0.8,-0.2><0,0,0> rotate <0,0,-30> translate <-0.4,-1.1,0> }
    box { <-0.1,-0.8,-0.2><0,0,0> rotate <0,0,-30> translate < 0.0,-1.1,0> }
    box { <-0.1,-0.8,-0.2><0,0,0> rotate <0,0,-30> translate < 0.4,-1.1,0> }
    box { <-0.1,-0.8,-0.2><0,0,0> rotate <0,0,-30> translate < 0.8,-1.1,0> }
    pigment { Black }
    scale <0.7,0.7,1>
    translate <-2.2,1,0>
  }
  scale 1.2
  translate <0,7,0>
}

#declare Arrow =
union {
  cylinder { <0,-5,0><0,2,0> 0.5 }
  cone { <0,2,0> 1.5 <0,5,0> 0 }
  //pigment { Black }
}

#declare _Cloud =
blob {
  threshold 0.65
  sphere { <-0.7, 0.2, 0.0>, 0.7, 1 pigment {Gray65} }
  sphere { <-0.3, 0.0, 0.0>, 0.8, 1 pigment {Gray75} }
  sphere { < 0.3, 0.0, 0.0>, 0.9, 1 pigment {Gray70} }
  sphere { < 0.8, 0.1, 0.0>, 0.8, 1 pigment {Gray65} }

  sphere { <-0.5, 0.0, 0.5>, 0.8, 1 pigment {Gray80} }
  sphere { < 0.6, 0.1, 0.6>, 0.8, 1 pigment {Gray60} }

  sphere { <-0.7, 0.7, 0.4>, 0.9, 1 pigment {Gray60} }
  sphere { <-0.2, 0.6, 0.5>, 0.7, 1 pigment {Gray80} }
  sphere { < 0.5, 0.8, 0.4>, 0.8, 1 pigment {Gray70} }

  sphere { <-0.4, 0.5, 0.0>, 0.9, 1 pigment {Gray55} }
  sphere { < 0.3, 0.7,-0.1>, 0.8, 1 pigment {Gray95} }
  sphere { <-0.4, 0.4,-0.4>, 0.8, 1 pigment {Gray25} }

  finish { phong 1 }
  scale 3
}

#declare Forecast =
union {
  object { _Sun scale 0.5 translate <5,6,0> }
  text { ttf "timrom.ttf" "?" 1, 0  scale <12,12,0.5> translate <-1,2,-4> pigment { Red } finish { ambient 0.5 } }
  object { _Cloud translate <-5,5,0> }
  union {
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <0,0,0> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <4,2,2> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <2,1,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <5,2,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <1,2,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <3,2,0> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <2,0,0> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <1,1,2> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <0,1,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <4,2,2> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <5,1,0> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <3,2,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <3,1,1> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <3.5,0.5,2> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <1,1,0> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <0.5,0,2> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <3,0,0.5> pigment { color Blue } }
    sphere { < 0, 0, 0> 1 scale <0.1,1,0.1> rotate <0,0,-30> translate <1,0,0.5> pigment { color Blue } }
    translate <-8,1,-1> 
  }
  object { Plate }
}

#declare SunRaise =
union {        
  object { _Sun  scale 0.7 translate <-4,6,0> }
  object { Arrow translate <5,7,0> pigment { Black }}
  object { Plate }
}

#declare SunSet =
union {        
  object { _Sun  scale 0.7 translate <-4,6,0> }
  object { Arrow scale <1,-1,1> translate <5,7,0> pigment { White } finish { ambient 0.5 } }
  object { Plate }
}

#declare Hum =
union {
  object { _Hum translate <2,0,-2> }
  object { Plate }
}
#declare Heat =
union {
  object { _Sun   translate <-15,5,10> }
  object { Termo }
  object { Plate }
}
#declare Chill =
union {
  object { _WindS translate <-3,0,-2> }
  object { Termo  translate < 3,0, 2> }
  object { Plate }
}
#declare Date=
union {
  object { Plate }
  object { _Date }
}
#declare Temp=
union {
  object { Plate }
  object { Termo }
}
#declare WindS =
union {
  object { Plate }
  object { _WindS }
}
#declare WindD =
union {
  object { Plate }
  object { _WindD }
}
#declare Drew =
union {
  object { Plate }
  object { _Drew }
}
#declare Rain =
union {
  object { Plate }
  object { _Rain }
}
#declare Baro =
union {
  object { _Baro }
  object { Plate }
}

object {
  #if (CLK=0)
    Date
  #end
  #if (CLK=1)
    Temp
  #end
  #if (CLK=2)
    Rain
  #end
  #if (CLK=3)
    WindD
  #end
  #if (CLK=4)
    WindS
  #end
  #if (CLK=5)
    Drew
  #end
  #if (CLK=6)
    Chill
  #end
  #if (CLK=7)
    Heat
  #end
  #if (CLK=8)
    Hum
  #end
  #if (CLK=9)
    Baro
  #end
  #if (CLK=10)
    SunRaise
  #end
  #if (CLK=11)
    SunSet
  #end
  #if (CLK=12)
    Forecast
  #end
  
  rotate <0,30,0>
  rotate <-30,0,0>
  translate <0,-5,0>
}

light_source { 
  <-3000, 2000, -10000> 
  colour rgb <1.0, 1.0, 1.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 color rgb <0.7, 0.7, 1.0>]
      [0.5 color rgb <0.3, 0.3, 0.8>]
      [1.0 color rgb <0.7, 0.7, 1.0>]
    }
    scale 0.2
  }  
}

camera {
   location <0,0,-100>
   direction <0.0, 0.0, 6>
   up <0.0, 1.0, 0.0>      // Kwadratisch
   right <1.0, 0.0, 0.0>
   look_at <0,-1,0>
}
